# HtmlForge

# Обзор
HtmlForge — это плагин, который обрабатывает теги `<html>` в разметке документов, отображая содержимое из секций CDATA и заменяя каждый тег `<html>` растровым изображением в теге `<image>`.

# Возможности:

Плагин HtmlForge предоставляет поддержку языка разметки HTML, тем самым позволяя выполнять кастомизацию документов в широком диапазоне, включая:
* **Шрифты и стили**: Поддерживает большой выбор шрифтов и опций стилей, таких как выравнивание текста, межстрочный интервал и др. Шрифты не ограничены моноширинными типами и по-прежнему сохраняют правильное выравнивание столбцов в таблице.
* **Поддержка множества языков**: Поддерживает большинство языков без ограничений на кодовые страницы принтера.
* **Поддержка RLT и LTR текста**: Поддерживает написание текста слева направо и справа налево.
* **Поддержка графики**: Обеспечивает интеграцию как растровой, так и векторной графики, например, формата SVG, для включения логотипов, значков и пиктограмм в ваши документы.
* **Расширенное форматирование таблиц**: Позволяет создавать сложные макеты HTML-таблиц, включая вложенные таблицы и комбинированный текст и графику в таблице.
* **Поддержка JavaScript**: Позволяет выполнять окончательную корректировку для оптимальной разметки.

# Компоненты и установка

## Установка
Скопируйте папку **'Resto.Front.Api.HtmlForge'** в подпапку **'Plugins'** в директории приложения Front.

## Используемые компоненты:
* **Firefox**: Используется для рендеринга HTML-контента.
* **GeckoDriver**: Используется для автоматизации задач в Firefox.
Оба компонента, Firefox и GeckoDriver, включены в состав плагина, и их дополнительная установка или настройка не требуется.

### Файл конфигурации плагина
Настройки плагина хранятся в файле `HtmlForge.config` в директории `PluginConfigs`, которая находится в %AppData%:

**RenderedImageSaveToFile** Определяет, нужно ли сохранять отрендеренные изображения (PNG) на диск: "true" — сохранять, "false" — не сохранять.

**RenderedImageMaxAgeDays** Устанавливает максимальное количество дней хранения отрендеренных изображений на диске перед их удалением.

**GeckoDriverWatchdogEnabled** Определяет, следует ли запускать и отслеживать процесс watchdog для Gecko Driver. Установите `"true"`, чтобы включить watchdog, который будет управлять запуском и перезапуском Gecko Driver при необходимости, или `"false"`, чтобы отключить его.

**GeckoDriverWatchdogLoggingEnabled** Определяет, необходимо ли включить логи watchdog для Gecko Driver. Логи находятся по следующему пути:

`%AppData%\EntitiesStorage\Plugins\<PluginName>\Outputs\watchdog.log`

# Пример использования
Вот пример, демонстрирующий использование HtmlForge для обработки тега `<html>`:
```
<doc>
    <html>
        <![CDATA[
<p>Hello, world</p>
        ]]>
    </html>
</doc>
```

Можно также использовать более простой подход с помощью синтаксического сахара для разметки с одним тегом `<html>`:
```
<!DOCTYPE html>
<html>
  <p>Hello, world</p>
</html>
```

При печати этот шаблон должен создать документ, отображающий текст "Hello, world".

# Информация о лицензии

## Стороннее программное обеспечение

#### Firefox
Firefox лицензирован под Mozilla Public License 2.0 (MPL 2.0). Для получения дополнительной информации см. файл `Licenses/LICENSE_Mozilla.txt`.

Исходный код версии, включённой в данный продукт, доступен по адресу: https://hg.mozilla.org/releases/mozilla-release/rev/1c2603279ac3bf5c442bf416ee7bf6d7d2c20d31
Исходный код всех версий Firefox можно найти по адресу: https://archive.mozilla.org/pub/firefox/releases

Дополнительно, информация о лицензии Firefox доступна при вводе `about:license` в адресной строке браузера. Информация об исходном коде и параметрах сборки доступна через `about:buildconfig`.

#### Selenium
Selenium лицензируется по лицензии Apache License 2.0. Подробности см. в файле `Licenses/LICENSE_Selenium.txt`. С уведомлением об авторском праве можно ознакомиться в файле `Licenses/NOTICE_Selenium.txt`.

#### GeckoDriver
GeckoDriver лицензируется по Mozilla Public License 2.0 (MPL 2.0). Подробности см. в файле `Licenses/LICENSE_Mozilla.txt`.

Исходный код версии, включённой в данный продукт, доступен по адресу: https://github.com/mozilla/geckodriver/archive/refs/tags/v0.34.0.zip
Исходный код всех версий GeckoDriver можно найти по адресу: https://github.com/mozilla/geckodriver/releases

#### SkiaSharp
SkiaSharp лицензируется по лицензии MIT. Подробности см. в файле `Licenses/LICENSE_SkiaSharp.txt`.
