# HtmlForge

# Overview
HtmlForge is a plugin that processes `<html>` tags in document markups by rendering content from CDATA sections and replacing each `<html>` tag with a bitmap in an `<image>` tag.

# Capabilities:

HtmlForge plugin enables a wide range of HTML features, allowing for broad customization and adapting to document needs, including:
* **Fonts and Styling**: Supports extensive choice of fonts and style options, such as text alignment, line spacing. Fonts are not limited to monospaced types and still maintain proper column alignment in a table.
* **Multi-Language Support**: Enables integration of multiple languages, unrestricted by printer codepages.
* **Bidirectional Text Support**: Handles both left-to-right and right-to-left scripts.
* **Graphic Support**: Enables integration of both raster and vector graphics, such as SVG format, for including logos, icons, and pictograms in your documents.
* **Advanced Table Formatting**: Enables complex HTML tables layouts, including nested tables and mixed text and graphics in a table.
* **Javascript support**: Enables final adjustments for optimal layout.

# Components and Installation

## Installation
Copy the **'Resto.Front.Api.HtmlForge'** folder under the **'Plugins'** subfolder within the Front application directory.

## Bundled Components
* **Firefox Browser**: Used for rendering HTML content.
* **GeckoDriver**: Used to automate Firefox tasks.

Both Firefox and GeckoDriver are bundled with the plugin, and no additional installation or configuration is required for these components.

## Plugin Configuration File

Configure the plugin by setting the following keys in the **'HtmlForge.config'** file in the **'PluginConfigs'** directory within `%AppData%`

**RenderedImageSaveToFile**: Controls whether the rendered PNG images are saved to the file system. Set to `"true"` to enable saving, and `"false"` to disable.

**RenderedImageMaxAgeDays**: Specifies the maximum number of days that rendered images are stored on disk before being deleted.

**GeckoDriverWatchdogEnabled**: Specifies whether the Gecko Driver watchdog process should be launched and monitored. Set to `"true"` to enable the watchdog, which will restart and manage the Gecko Driver as needed, or `"false"` to disable it.

**GeckoDriverWatchdogLoggingEnabled**: Specifies whether to enable logging for Gecko Driver watchdog process. Logs are stored in the following location:

`%AppData%\EntitiesStorage\Plugins\<PluginName>\Outputs\watchdog.log`

# Usage Example
Here's an example that demonstrates how to use HtmlForge for processing `<html>` tag:
```
<doc>
    <html>
        <![CDATA[
<p>Hello, world</p>
        ]]>
    </html>
</doc>
```

Alternatively, you can utilize a more straightforward approach by using syntax sugar for markup with a single `<html>` tag:
```
<!DOCTYPE html>
<html>
  <p>Hello, world</p>
</html>
```

When printed, this template should produce a document displaying the text "Hello, world".

# License Information

## Third-Party Software

#### Firefox
Firefox is licensed under the Mozilla Public License 2.0 (MPL 2.0). For more details, see the `Licenses/LICENSE_Mozilla.txt` file.

The source code for the version included in this product can be found at: https://hg.mozilla.org/releases/mozilla-release/rev/1c2603279ac3bf5c442bf416ee7bf6d7d2c20d31
The source code for all Firefox versions is available at: https://archive.mozilla.org/pub/firefox/releases/

Additionally, license information for Firefox can be accessed by entering `about:license` in the browser's address bar. Information about the source code and build configuration is available via `about:buildconfig`.

#### Selenium
Selenium is licensed under the Apache License 2.0. For more details, see the `Licenses/LICENSE_Selenium.txt` file. The copyright notice can be found in the `Licenses/NOTICE_Selenium.txt` file.

#### GeckoDriver
GeckoDriver is licensed under the Mozilla Public License 2.0 (MPL 2.0). For more details, see the `Licenses/LICENSE_Mozilla.txt` file.

The source code for the version included in this product can be found at: https://github.com/mozilla/geckodriver/archive/refs/tags/v0.34.0.zip
The source code for all GeckoDriver versions is available at: https://github.com/mozilla/geckodriver/releases

#### SkiaSharp
SkiaSharp is licensed under the MIT License. For more details, see the `Licenses/LICENSE_SkiaSharp.txt` file.
