'use strict';
// Фильтр для вывода заданного количества элементов массива
//   (недостающие элементы вставляются в виде null-объектов)
app.filter('limitToRange',
function() {
	return function(input, limit, begin) {
		if (Math.abs(Number(limit)) === Infinity) {
			limit = Number(limit);
		} else {
			limit = parseInt(limit, 10);
		}
		if (isNaN(limit)) result = input;

		if (angular.isNumber(input)) return input.toString();
		if (!angular.isArray(input) && !angular.isString(input)) return input;

		begin = (!begin || isNaN(begin)) ? 0 : parseInt(begin, 10);
		begin = (begin < 0) ? Math.max(0, input.length + begin) : begin;

		var result = null;
		if (limit >= 0) {
			result = input.slice(begin, begin + limit);
		} else {
			if (begin === 0) {
				result = input.slice(limit, input.length);
			} else {
				result = input.slice(Math.max(0, begin + limit), begin);
			}
		}
		var emptyItemsLength = limit - result.length;
		for (var i = 0; i < emptyItemsLength; i++) {
			result.push(null);
		};
		return result;
	};
});