'use strict';
// Сервис для работы с контентом
//   (изображения, директории и т.д.)
app.service('contentService', ['$http', 'config',
function ($http, config) {
	var contentDir = '/content/';
	var imagesDir = contentDir + 'images/';
	var fullscreenImagesDir = contentDir + 'images-fullscreen/';

	// Получить файлы из директории
	function getDirectoryContent(path) {
		return $http.get(path).then(function (res) {
			var contentType = res.headers()['content-type'];
			if (contentType.indexOf('application/json') == 0) {
				for (var i = 0; i < res.data.length; i++) {
					res.data[i] = encodeURI(res.data[i]);
				}
				return res.data;
			}
			else if (contentType.indexOf('text/html') == 0) {
				var dirs = [];
				var href = res.data.lastIndexOf('th');
				while ((href = res.data.indexOf('href="', href + 1)) >= 0) {
					var start = href + 6;
					var finish = res.data.indexOf('"', start);
					var content = res.data.slice(start, finish);
					if (content.indexOf(path) == 0) {
						content = content.slice(path.length, content.length);
					}
					if (content[content.length - 1] == '/') {
						content = content.slice(0, content.length - 1);
					}
					dirs.push(content);
				}
				return dirs;
			}
		});
	}

	// Получить изображения из директории
	function getImagesFromDirectory(dir) {
		return getDirectoryContent(dir).then(function (images) {
			for (var i = 0; i < images.length; i++) {
				images[i] = dir + images[i];
			}
			return images;
		});
	}

	// Получить рекламные изображения (на половину экрана)
	function getImages() {
		return getImagesFromDirectory(imagesDir);
	}

	// Получить рекламные изображения (на весь экран)
	function getFullscreenImages() {
		return getImagesFromDirectory(fullscreenImagesDir);
	}


	// Получить контент
	function getContent(fileName) {
		if (fileName) {
			return contentDir + fileName;
		}
	}

	// Получить следующее изображение из массива (циклично)
	function getNextImage(images, currentImage) {
		if (!images || !images.length){
			return;
		}
		var index = images.indexOf(currentImage) + 1;
		if (index >= images.length){
			index = 0;
		}
		return images[index];
	}

	return {
		getDirectoryContent: getDirectoryContent,
		getImages: getImages,
		getFullscreenImages: getFullscreenImages,
		getNextImage: getNextImage,
		completeStatusImage: getContent(config.completeStatusImage),
		backgroundImage: getContent(config.backgroundImage),
		logoImage: getContent(config.logoImage),
		notResponseImage: getContent(config.notResponseImage),
		licenseLimitImage: getContent(config.licenseLimitImage),
		orderCompleteSound: getContent(config.orderCompleteSound)
	};
}]);