'use strict';
// Сервис аутентифиуации
app.service('authService', ['$http', '$cookies', 'config',
function ($http, $cookies, config) {

	function getKey (key) {
		return $cookies.get('key')
	}

	function setKey (key) {
		$cookies.put('key', key, {expires: new Date(3000, 0)});
	}

	function removeKey () {
		$cookies.remove('key');
	}

	function login() {
		removeKey();
		return $http.get(config.webServiceUrl + '/api/login/13550').then(function (res) {
			setKey(res.data);
		});
	}

	return {
		login: login,
		getKey: getKey
	};
}]);