'use strict';
// Обработчик запросов
//   (конфигурация запросов, перехват неавторизованных запросов и т.д.)
app.factory('authInterceptor', ['$q', '$injector',
function ($q, $injector) {

		function request(req) {
			var auth = $injector.get('authService');
			var config = $injector.get('config');

			setKey(req);
			req.timeout = +config.notResponseTimeout * 1000;
			return req;
		}

		function setKey(req) {
			var auth = $injector.get('authService');
			var key = auth.getKey();
			if (key) {
				if (!req.params) {
					req.params = {};
				}
				req.params.key = key;
				return true;
			}
		}

		function responseError(res) {
			var auth = $injector.get('authService');
			var $http = $injector.get('$http');

			res.licenseLimitError = res.status === 403 && res.data && res.data.Message &&
				res.data.Message.indexOf('Cannot acquire slot for module') >= 0;
			
			if (!res.licenseLimitError && (res.status === 401 || res.status === 403)) {
				return auth.login().then(function () {
					return $http(res.config);
				});
			}
			
			res.notFound = res.status === 404 && res.data && res.data.Message &&
				res.data.Message.indexOf('Item Not Found') >= 0;
			if (res.notFound) {
				return $q.resolve(null);
			}

			return $q.reject(res);
		}

	return {
		request: request,
		responseError: responseError
	};
}]);