'use strict';
// Контроллер страниц шаблонов заказов
app.controller('ordersController', ['$scope', '$timeout', '$interval', '$q', 'config', 'ordersService', 'contentService', 'ngAudio',
function ($scope, $timeout, $interval, $q, config, ordersService, contentService, ngAudio) {
	
	var images, fullscreenImages, refreshImageTimer, hasError, splashOrderTimer,
		hideSplashOrderTimer, splashOrders = [], orderCompleteSound,
		currentPage = 0, changePageTimer, ordersRefreshingIsInProgress, stylesApplied, orderHeight;
	$scope.hasMarketing = function () {
		return !!$scope.marketingVideoUrl || !!$scope.marketingSource;
	};
	$scope.isVideo = function (src) {
		return src && /\.mp4($|\?)/i.test(src);
	};

	// Вывод текущего времени
	function refreshTime() {
		$scope.time = new Date();
	}

	// Вывод заказов
	function refreshOrders() {
		if (ordersRefreshingIsInProgress) {
			return;
		}
        ordersRefreshingIsInProgress = true;
		ordersService.getOrders()
			.then(function (orders) {
				$scope.orders = orders;

				// Запускаем смену рекламных изображений если:
				if (hasError // была ошибка;
					|| !$scope.fullscreenImage && !$scope.image // изображения ещё не загружались;
					|| $scope.fullscreenImage && orders.length // изображение во весь экран нужно сменить на пол-экрана;
					|| !$scope.fullscreenImage && !orders.length) { // изображение на пол-экрана нужно сменить на весь экран.
					hasError = false;
					refreshImage();
				}

				ordersService.updateSplashOrders(splashOrders, orders);
				if (!angular.isDefined(splashOrderTimer)) {
					showSplash();
				}
				if (!angular.isDefined(changePageTimer)) {
					initPaging();
				}
				ordersRefreshingIsInProgress = false;
				stylesApplied = false;
			}, function (error) {
				showError(error);
				ordersRefreshingIsInProgress = false;
				stylesApplied = false;
			});
	}

	// Смена рекламного изображения
	function refreshImage() {
		if (hasError) {
			return;
		}
		var isFullscreenMode = $scope.orders && !$scope.orders.length;
		if (isFullscreenMode) {
			$scope.image = null;
			$scope.fullscreenImage = contentService.getNextImage(fullscreenImages, $scope.fullscreenImage);
			playMedia($scope.fullscreenImage);
		} else {
			$scope.fullscreenImage = null;
			$scope.image = contentService.getNextImage(images, $scope.image);
			playMedia($scope.image);
		}
	}

	// Проверить, что медиафайл является видео
	function isVideo(fileName) {
		return fileName && fileName.indexOf('.mp4') >= 0;
	}

	// Воспроизвести медиафайл
	function playMedia(media) {
		stopMedia();
		if (isVideo(media)) {
			$timeout(function () {
                var videoControls = document.getElementsByClassName('video');
				if (videoControls.length) {
					try {
						videoControls[0].onended = refreshImage;
						videoControls[0].load();
						videoControls[0].play();
					} catch (e) {
						var video = $("video");
						if (video && video.paused)
							video.play();
					}
                }
			}, 1000);
		} else {
			refreshImageTimer = $timeout(refreshImage, +config.imageChangeTimeout * 1000);
		}
	}

	// Остановить воспроизведение медиафайла
	function stopMedia() {
		$timeout.cancel(refreshImageTimer);
		var videoControls = document.getElementsByClassName('video');
		if (videoControls.length) {
			videoControls[0].pause();
		}
	}

	// Загрузить контент
	function loadContent() {
		$q.all([contentService.getImages(), contentService.getFullscreenImages()])
		.then(function (imgs) {
			images = imgs[0];
			fullscreenImages = imgs[1];
			if (contentService.orderCompleteSound) {
				orderCompleteSound = ngAudio.load(contentService.orderCompleteSound);
			}
		});
	}

	// Показать всплывающее окно с приготовленным заказом
	function showSplash() {
		$scope.splashOrder = ordersService.getSplashOrder(splashOrders);
		$scope.visibleSplashOrder = !!$scope.splashOrder;
		if ($scope.splashOrder) {
			playSound();
			hideSplashOrderTimer = $interval(hideSplash, +config.splashShowTimeout * 1000, 1);
			if (!angular.isDefined(splashOrderTimer)) {
				splashOrderTimer = $interval(showSplash, +config.splashChangeTimeout * 1000);
			}
		} else if (angular.isDefined(splashOrderTimer)) {
			$interval.cancel(splashOrderTimer);
			splashOrderTimer = undefined;
		}
	}
	
	// Скрыть всплывающее окно с приготовленным заказом
	function hideSplash() {
		$scope.visibleSplashOrder = false;
		if (angular.isDefined(hideSplashOrderTimer)) {
			$interval.cancel(hideSplashOrderTimer);
			hideSplashOrderTimer = undefined;
		}
	}

	// Воспроизвести звук приготовления заказа
	function playSound () {
		if (!orderCompleteSound) return;
		
		if (orderCompleteSound.paused !== false) {
			orderCompleteSound.play();
		} else {
			orderCompleteSound.progress = 0;
		}
	}

	// Отобразить ошибку
	function showError(err) {
		hasError = true;
		stopMedia();
		if (err && err.licenseLimitError) {
			$scope.fullscreenImage = contentService.licenseLimitImage;
		}
		else {
			$scope.fullscreenImage = contentService.notResponseImage;
		}
	}

	// Инициализация смены страниц заказов
	function initPaging() {
		if (config.paging && config.paging.timeout && config.paging.pageSize) {
			$scope.pageSize = +config.paging.pageSize;
			changePageTimer = $interval(changePage, +config.paging.timeout * 1000);
			changePage();
		}
	}

	// Смена страницы заказов
	function changePage() {
		if (!$scope.orders || !$scope.orders.length) {
			$scope.ordersPage = [];
		}
		if (currentPage >= $scope.orders.length / $scope.pageSize) {
			currentPage = 0;
		}
		$scope.ordersPage = $scope.orders.slice(currentPage * $scope.pageSize, (currentPage + 1) * $scope.pageSize);
		currentPage++;
	}
	function updateStyles() {
		if (ordersRefreshingIsInProgress || stylesApplied) {
			return;
		}
		if (config.numberStyles && config.numberStyles.fontSizeForLargeNumber && config.numberStyles.fontSize) {
			var ordersElements = document.getElementsByClassName("order-number");
			for (var i = 0; i < ordersElements.length; i++) {
				var el = ordersElements[i];
				if (el.innerText.length > config.orderNumberLength)
					el.style.fontSize = config.numberStyles.fontSizeForLargeNumber + "px";
				else
					el.style.fontSize = config.numberStyles.fontSize + "px";

				if (orderHeight)
					el.style.height = orderHeight;
			}
		}
		stylesApplied = true;
	}
	function checkRowsCount() {
		if (config.rowsCount) {
			var height = 0
			if (document.getElementsByClassName("orders-container")[0])
				height = document.getElementsByClassName("orders-container")[0].getBoundingClientRect().height;

			var elHeight = 0;
			if (document.getElementsByClassName("order-number")[0])
				elHeight = document.getElementsByClassName("order-number")[0].getBoundingClientRect().height;

			if (height == 0 || elHeight == 0)
				return;
			document.getElementsByClassName("order-number")[0].style.fontSize = config.numberStyles.fontSize + "px";
			elHeight = document.getElementsByClassName("order-number")[0].getBoundingClientRect().height;

			var heightForEl = height / config.rowsCount;

			var els = document.getElementsByClassName("order-number");
			for (var i = 0; i < els.length; i++) {
				els[i].style.height = heightForEl + "px";
			}
			orderHeight = heightForEl + "px";

			var elHeight2 = document.getElementsByClassName("order-number")[0].getBoundingClientRect().height;
			console.log(height, elHeight, elHeight2, heightForEl);
			if (elHeight2 - heightForEl > 1) {
				var maxRowsCount = Math.floor(height / elHeight);
				var acceptableErrorLimit = 0.1;
				var maxRowsCountWithLimit = Math.floor((height / elHeight2) + acceptableErrorLimit);
				if (maxRowsCount != maxRowsCountWithLimit)
					maxRowsCount = maxRowsCountWithLimit;
				console.log(maxRowsCount, config.rowsCount);
				if (maxRowsCount < config.rowsCount) {
					alert("Рекомендуемое количество строк - " + maxRowsCount);
				}
			}
			stylesApplied = false;
		}
	}

	$scope.completeStatusImage = contentService.completeStatusImage;
	$scope.logoImage = contentService.logoImage;
	$scope.backgroundImage = contentService.backgroundImage;
	$scope.customRowsCount = config.rowsCount ? config.rowsCount : null;
	var refreshTimeTimer = $interval(refreshTime, 1000);
	var refreshOrdersTimer = $interval(refreshOrders, +config.ordersRefreshTimeout * 1000);
	var clearConsoleTimer = $interval(console.clear(), 5 * 60 * 1000);
	var updateStylesTimer = $interval(updateStyles, 10);
	$timeout(checkRowsCount, 2000);
	refreshTime();
	refreshOrders();
	loadContent();

	// Уничтожение всех таймеров при уничтожении страницы
	$scope.$on("$destroy", function (event) {
		$interval.cancel(refreshTimeTimer);
		$interval.cancel(refreshOrdersTimer);
		$interval.cancel(refreshImageTimer);
		$interval.cancel(clearConsoleTimer);
		$interval.cancel(updateStylesTimer);
		if (splashOrderTimer) {
			$interval.cancel(splashOrderTimer);
		}
		if (hideSplashOrderTimer) {
			$interval.cancel(hideSplashOrderTimer);
		}
		if (changePageTimer) {
			$interval.cancel(changePageTimer);
		}
	});
	$scope.isVideo = isVideo;
}]);
