'use strict';
var app = angular.module('app', ['ngRoute', 'ngCookies', 'ngAnimate', 'ngAudio']);

app.config(['$routeProvider', '$httpProvider', 'configProvider',
function ($routeProvider, $httpProvider, config) {
	$httpProvider.interceptors.push('authInterceptor');

	$routeProvider
	.when('/', {
		controller: 'homeController',
		templateUrl: '/app/views/home.html'
	})
	.when('/:template', {
		controller: 'ordersController',
		templateUrl: function(params){
			return '/templates/' + params.template + '/index.html';
		}
	})
	.otherwise({ redirectTo: '/' });
}]);